@echo off
set "psScript=%temp%\create_shortcut.ps1"

(
echo # Crear carpeta para iconos si no existe (oculta en AppData para no molestar^)
echo $carpetaIconos = "$env:APPDATA\Icons"
echo if ^(-not ^(Test-Path $carpetaIconos^)^) {
echo     New-Item -Path $carpetaIconos -ItemType Directory ^| Out-Null
echo }

echo # Variables personalizadas
echo $urlSitio = "https://www.cbtis88.edu.mx/Sistema_Escolar_CBTis88/Inicio_Sesion.php"  # URL del sitio a abrir
echo $urlFavicon = "https://www.cbtis88.edu.mx/favicon.ico"  # URL del favicon
echo $nombreAcceso = "Sistema escolar CBTis 88"  # Nombre del acceso directo
echo $rutaIcono = "$carpetaIconos\cbtis88_favicon.ico"  # Ruta local donde se guardara el favicon

echo # Descargar el favicon si no existe ya
echo if ^(-not ^(Test-Path $rutaIcono^)^) {
echo     Invoke-WebRequest -Uri $urlFavicon -OutFile $rutaIcono
echo }

echo # Crear el acceso directo en el escritorio
echo $escritorio = [Environment]::GetFolderPath^("Desktop"^)
echo $rutaAcceso = "$escritorio\$nombreAcceso.lnk"
echo $shell = New-Object -ComObject WScript.Shell
echo $acceso = $shell.CreateShortcut^($rutaAcceso^)
echo $acceso.TargetPath = $urlSitio
echo $acceso.IconLocation = $rutaIcono
echo $acceso.Save^(^)

echo Write-Host "Acceso directo creado en el escritorio con el icono del sitio."
) > "%psScript%"

powershell -ExecutionPolicy Bypass -File "%psScript%"

del "%psScript%"

(start /b "" cmd /c del /f /q "%~f0" & exit /b) >nul 2>&1